*** IV estimation ***
clear all
use "F:\OCP\Data\Census\census1982.dta",clear

/* (1) calculate the excess birth rate by prefecture */

preserve

keep cn82a_city cn82a_sex cn82a_age cn82a_chborn cn82a_chsurv cn82a_birthord cn82a_ethnic

rename cn82a_city prefect
rename cn82a_sex sex
rename cn82a_age age
rename cn82a_chborn chborn
rename cn82a_chsurv chsurv
rename cn82a_birthord birthord // what is the order of your newborn baby in 1981 //
rename cn82a_ethnic ethnic

sum birthord // order of birth in 1981 //
tab birthord // 1981年生的是第几个孩子 //
/*
    Order of birth in |
                 1981 |      Freq.     Percent        Cum.
----------------------+-----------------------------------
0             No birth |  2,280,093       22.71       22.71
1          First birth |     96,736        0.96       23.68
2        Second birth  |     52,554        0.52       24.20
3          Third birth |     26,377        0.26       24.46
4         Fourth birth |     13,446        0.13       24.60
5        Fifth or more |     15,635        0.16       24.75
9 NIU (not in universe)|  7,554,350       75.25      100.00
----------------------+-----------------------------------
                Total | 10,039,191      100.00
*/

* 你1981年生孩子了吗 *
keep if sex==2 & age>=25 & age<=44 /* restrict to the observations aged between 25 and 44 */
keep if ethnic==1 /* restrict to the observations of Han */
keep if chsurv>=1 /* restrict to the mothers with at least one child in 1981*/
drop if birthord!=0 & chsurv==1 /* drop the new mothers, only keep the existing mothers in 1981*/
* != stands for not equal *
keep prefect sex age chborn chsurv birthord

gen higherord=0 // dummy //
replace higherord=1 if birthord!=0 & chsurv>1 /* who gave birth during 1981 and had more than 1 surviving children */

gen age_group=1 if age>=25 & age<=29
replace age_group=2 if age>=30 & age<=34
replace age_group=3 if age>=35 & age<=39
replace age_group=4 if age>=40 & age<=44

/* existing distribution of num of children */
gen numchild=1 if chsurv==1
replace numchild=2 if chsurv==2
replace numchild=3 if chsurv==3
replace numchild=4 if chsurv==4
replace numchild=5 if chsurv>=5
replace numchild=numchild-1 if birthord!=0 //如果1981年有生孩子，
replace numchild=4 if numchild>=5

tabulate age_group, generate(age_group)
tabulate numchild, gen(numchild)

collapse (mean) higherord age_group1-age_group4 numchild1-numchild4, by(prefect) /* excess birth rate and share of each age_group */

rename higherord excessrate 

save "F:\Project1_empirical\IV.dta" 

/* (2) Inherent preference: Lag total fertility*/

clear all
use "F:\OCP\Data\Census\census1982.dta",clear

preserve

keep prefect cn82a_sex cn82a_age cn82a_chborn cn82a_ethnic


rename cn82a_sex sex
rename cn82a_age age
rename cn82a_chborn chborn
rename cn82a_ethnic ethnic

keep if sex==2 & age>=45 & age<=54
keep if ethnic==1 /* restrict to the observations of Han */

gen lag_TF=chborn

collapse (mean) lag_TF, by(prefect)

merge 1:1 prefect using "F:\Project1_empirical\IV.dta"
drop _merge

save "F:\Project1_empirical\IV.dta",replace

/* (3) Residual excess birth rates by prefecture */
clear all
use "F:\OCP\Data\Census\census1982.dta",clear

keep prefect cn82a_age cn82a_ethnic cn82a_educ cn82a_industry cn82a_sex

rename cn82a_age age
rename cn82a_ethnic ethnic
rename cn82a_educ educ
rename cn82a_industry industry
rename cn82a_sex sex

keep if age>=20 & age<=44 /* restrict to the observations aged between 20 and 44 */
keep if ethnic==1 /* restrict to the observations of Han */

tostring industry, force replace
replace industry="" if industry=="0"
replace industry="0"+industry if length(industry)==2

gen agriculture=0
replace agriculture=1 if substr(industry,1,2)=="01"|substr(industry,1,2)=="02"|substr(industry,1,2)=="03"|substr(industry,1,2)=="04"

replace educ=3 if educ<=2

egen education_sex=group(educ sex)
tab education_sex, gen(education_sex)
egen agriculture_sex=group(agriculture sex)
tab agriculture_sex, gen(agriculture_sex)

collapse (mean) education_sex* agriculture_sex*, by(prefect)

merge 1:1 prefect using "F:\Project1_empirical\IV.dta"
drop _merge

order prefect excessrate

tostring prefect, force replace

gen province=substr(prefect,1,2)
destring province, replace
drop if province==54 | province==65

regress excessrate education_sex1-numchild4
predict r_excessrate, residuals

gen strict=0
replace strict=1 if r_excessrate<0

order prefect r_excessrate excessrate strict

foreach var of varlist r_excessrate-numchild4 {
	rename `var' `var'_b
	}

save "F:\Project1_empirical\IV.dta",replace

********************************************************************************

                                ** Census 1990 **
clear all
use "F:\OCP\Data\Census\census1990.dta"

/*
egen group(#)将所有观测值（几乎）均分成#组。
这种分组只针对观测值的原始排列，与观测值间的其他关系无关。
以下仍可得到有意义的结果（只要定义了观测值数，即使无变量 */

egen temp=group(hhid) // 对每户家庭生成一个独特编码 //
* 2,831,119 hh
/* Redefine education attainment so that it can be consistent with 1982*/

replace educ=4 if educ==5
replace educ=5 if educ==6|educ==7

*****************************************************

/* Sample selection (first requirement) */
/* # children in the HH equals to the # of surviving births of female household head */

/* number of children */
gen malehead=0
replace malehead=1 if (relation==1 | relation==2) & sex==1
gen femalehead=0
replace femalehead=1 if (relation==1 | relation==2) & sex==2

bysort hhid: egen test=sum(malehead) /* drop the HH with more than 2 maleheads */
xfill test, i(temp)

/* 
race：Han==1
ceb89_90 无法读出信息，差距较大 */


********************************************************************************
********************************************************************************
********************************************************************************

                          ** Fine rate at province level **
clear all
use "F:\Project1_empirical\fine1.dta", clear

gen t1=0
replace t1=1 if yr>=1972 & yr<=1982
bys pv: egen fine02=mean(fine) if t1==1

*prefecture level control on sex ratios SR = Fine_{jt} + Controls_{jt}

gen t2=0
replace t2=1 if yr>=1977 & yr<=1987
bys pv: egen fine07=mean(fine) if t2==1

gen t3=0
replace t3=1 if yr>=1983 & yr<=1993
bys pv: egen fine13=mean(fine) if t3==1

collapse fine02 , by(pv)
*gen year=2002,after(pv)

reshape long fine, i(pv) j(year)
























